// SPON Rangefinder v0.3.0 (Addon version)
//
// Copyright (C) 2007-8 Bil Bas (bil {dot} bagpuss [at] gmail {dot} com / Spooner)
// License: GNU Lesser General Public License, version 3 <http://www.gnu.org/licenses/>

#ifndef SPON_ADDON
#define SPON_ADDON
#endif

// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Rangefinder\findLaserTarget
//
// Description:
//   Finds an individual's laser target.
//
// Parameters:
//   None.
//
// Returns:
//   Laser target for this player, or objNull if none found.
//
// -----------------------------------------------------------------------------

#include "macros\macros.inc.sqf"

#include "rangefinder.inc.sqf"

// -----------------------------------------------------------------------------

private ["_targetClass", "_targets", "_target", "_playerPos", "_dir",
	"_pos", "_distance", "_weaponVector"];
	
switch (playerSide) do
{
	case west:
	{
		_targetClass = "LaserTargetW";
	};
	case east:
	{
		_targetClass = "LaserTargetE";
	};
	default // Independent OR Civilian.
	{
		_targetClass = "LaserTargetC";
	};
};

_detectorPos = [0, 0, 0]; // Position of SPON_RF_targetDetector logic.

_target = objNull; // The laser target we are trying to find.

// Calculate direction of weapon.
_weaponVector = player weaponDirection SPON_RF_laserDesignatorClass;

SPON_TRACE_1("",_weaponVector);
	
// Step along the path, but only collide with the ground if we are well beneath it.
for [{_distance = DISTANCE_BETWEEN_CHECKS},
	{(_distance <= MAX_DISTANCE) and ((_detectorPos select 2) > -2) and (isNull _target)},
	{_distance = _distance + DISTANCE_BETWEEN_CHECKS}] do
{
	_detectorPos = positionCameraToWorld [0, 0, _distance];

	_targets = nearestObjects [_detectorPos, [_targetClass], RADIUS_OF_CHECK];
	
	SPON_TRACE_2("",_detectorPos,_targets);

	// If any of the detected targets lack an owner, then they must be ours.
	{
		_owner = _x getVariable LASER_TARGET_OWNER_VAR;
			
		SPON_TRACE_6("Detected laser target",_x,typeOf _x,_owner,player distance _x,_weaponVector,vectorDir _x);
		
		// Your own target has vectorDir equal to your weapon's dir.
		if ((isNil "_owner") and ((_weaponVector distance (vectorDir _x)) == 0)) exitWith
		{
			_target = _x;
		};
	} forEach _targets;
};

_target; // Return.

